define(['angular', 'app'], function (angular, app) {
    'use strict';
    app.service('FitnessCongratsService', function(FitnessCongratsConstants) {
        var FitnessCongratsService = {},
            localStorageKey = 'fitheart-congrats-dashboard',
            dashboard;
        
        FitnessCongratsService.getGoalReachedMessage = function() {
            return getNextMessage('goal-reached');            
        };

        FitnessCongratsService.getStandardMessage = function() {
            return getNextMessage('standard');
        };
        
        var getNextMessage = function(messageType) {
            var nextIndex = getNextIndex(messageType);
            return {
                title: FitnessCongratsConstants[messageType].title[nextIndex.title],
                text:  FitnessCongratsConstants[messageType].text[nextIndex.text]
            };            
        };

        var getNextIndex = function(messageType) {
            var titleLength = FitnessCongratsConstants[messageType].title.length,
                textLength  = FitnessCongratsConstants[messageType].text.length,
                currentTitleIndex = Number(dashboard[messageType].title),
                currentTextIndex  = Number(dashboard[messageType].text),
                nextIndex = {title: 0, text: 0},
                needUpdateLocalStore = false;

            if(currentTitleIndex < titleLength) {
                needUpdateLocalStore = true;
                nextIndex.title = currentTitleIndex++;
            } else {
                nextIndex.title = getRandom(titleLength);
            }
            
            if(currentTextIndex < textLength) {
                needUpdateLocalStore = true;
                nextIndex.text = currentTextIndex++;
            } else {
                nextIndex.text = getRandom(textLength);
            }
            
            if(needUpdateLocalStore) {
                dashboard[messageType].title = currentTitleIndex;
                dashboard[messageType].text  = currentTextIndex;
                saveLocalStorage(dashboard);
            }
            
            return nextIndex;
        };
        
        var getRandom = function(size) {
            return Math.floor((Math.random() * size));
        }
        
        var initDashboard = function() {
            return {
                'goal-reached': {title: 0, text: 0},
                'standard'    : {title: 0, text: 0}
            };                
        };

        FitnessCongratsService.fetchLocalStorage = function() {
            return JSON.parse(localStorage.getItem(localStorageKey));            
        };
        
        var saveLocalStorage = function(object) {
            localStorage.setItem(localStorageKey, JSON.stringify(object));
        };

        (function init() {
            dashboard = FitnessCongratsService.fetchLocalStorage();
            if(! dashboard) {
                dashboard = initDashboard();
                saveLocalStorage(dashboard);
            }
        })();

        return FitnessCongratsService;
    });    
});